/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class SimpleUpdater {
    private Plugin plugin;
    private int projectId;

    public SimpleUpdater(Plugin plugin, int projectId) {
        if (plugin == null) {
            throw new NullPointerException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.projectId = projectId;
    }

    public void checkForUpdates(final ResponseHandler responseHandler) {
        Thread updaterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONArray filesArray = (JSONArray)SimpleUpdater.this.readJson("https://api.curseforge.com/servermods/files?projectIds=" + SimpleUpdater.this.projectId);
                    if (filesArray.size() == 0) {
                        SimpleUpdater.this.plugin.getLogger().warning("The project ID (" + SimpleUpdater.this.projectId + ") provided for updating is invalid or curse had a problem.");
                        SimpleUpdater.this.plugin.getLogger().warning("If the error persists, please inform the author.");
                        return;
                    }
                    String updateName = (String)((JSONObject)filesArray.get(filesArray.size() - 1)).get((Object)"name");
                    final String newVersion = SimpleUpdater.this.extractVersion(updateName);
                    if (newVersion == null) {
                        throw new NumberFormatException();
                    }
                    if (SimpleUpdater.this.isNewerVersion(newVersion)) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask(SimpleUpdater.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                responseHandler.onUpdateFound(newVersion);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    SimpleUpdater.this.plugin.getLogger().warning("Could not contact BukkitDev to check for updates.");
                }
                catch (NumberFormatException e) {
                    SimpleUpdater.this.plugin.getLogger().warning("The author of this plugin has misconfigured the Updater system.");
                    SimpleUpdater.this.plugin.getLogger().warning("File versions should follow the format 'PluginName vVERSION'");
                    SimpleUpdater.this.plugin.getLogger().warning("Please notify the author of this error.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SimpleUpdater.this.plugin.getLogger().warning("Unable to check for updates: unhandled exception.");
                }
            }
        });
        updaterThread.start();
    }

    private Object readJson(String url) throws MalformedURLException, IOException {
        URLConnection conn = new URL(url).openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(8000);
        conn.addRequestProperty("User-Agent", "Updater (by filoghost)");
        conn.setDoOutput(true);
        return JSONValue.parse((Reader)new BufferedReader(new InputStreamReader(conn.getInputStream())));
    }

    private boolean isNewerVersion(String remoteVersion) {
        String pluginVersion = this.plugin.getDescription().getVersion();
        if (pluginVersion == null) {
            pluginVersion = "0";
        }
        if (!remoteVersion.matches("v?[0-9\\.]+")) {
            throw new IllegalArgumentException("fetched version's format is incorrect");
        }
        String[] pluginVersionSplit = pluginVersion.replace("v", "").replaceAll("[\\.]{2,}", ".").split("\\.");
        String[] remoteVersionSplit = remoteVersion.replace("v", "").replaceAll("[\\.]{2,}", ".").split("\\.");
        int longest = Math.max(pluginVersionSplit.length, remoteVersionSplit.length);
        int[] pluginVersionArray = new int[longest];
        int[] remoteVersionArray = new int[longest];
        int i = 0;
        while (i < pluginVersionSplit.length) {
            pluginVersionArray[i] = Integer.parseInt(pluginVersionSplit[i]);
            ++i;
        }
        i = 0;
        while (i < remoteVersionSplit.length) {
            remoteVersionArray[i] = Integer.parseInt(remoteVersionSplit[i]);
            ++i;
        }
        i = 0;
        while (i < longest) {
            int diff = remoteVersionArray[i] - pluginVersionArray[i];
            if (diff > 0) {
                return true;
            }
            if (diff < 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private String extractVersion(String input) {
        Matcher matcher = Pattern.compile("v[0-9\\.]+").matcher(input);
        String result = null;
        if (matcher.find()) {
            result = matcher.group();
        }
        return result;
    }

    public static interface ResponseHandler {
        public void onUpdateFound(String var1);
    }
}

