/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.block;

import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlockState;

public class CraftSign
extends CraftBlockState
implements Sign {
    private final apm sign;
    private final String[] lines;

    public CraftSign(Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.sign = (apm)world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
        if (this.sign == null) {
            this.lines = new String[]{"", "", "", ""};
            return;
        }
        this.lines = new String[this.sign.a.length];
        System.arraycopy(this.sign.a, 0, this.lines, 0, this.lines.length);
    }

    @Override
    public String[] getLines() {
        return this.lines;
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result) {
            this.sign.a = CraftSign.sanitizeLines(this.lines);
            this.sign.e();
        }
        return result;
    }

    public static String[] sanitizeLines(String[] lines) {
        String[] astring = new String[4];
        for (int i = 0; i < 4; ++i) {
            astring[i] = i < lines.length && lines[i] != null ? lines[i] : "";
        }
        return apm.sanitizeLines((String[])astring);
    }
}

