/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.dbplatform.AbstractDbEncrypt;
import com.avaje.ebean.config.dbplatform.DbEncryptFunction;

public class Oracle10DbEncrypt
extends AbstractDbEncrypt {
    public Oracle10DbEncrypt() {
        String encryptfunction = GlobalProperties.get("ebean.oracle.encryptfunction", "eb_encrypt");
        String decryptfunction = GlobalProperties.get("ebean.oracle.decryptfunction", "eb_decrypt");
        this.varcharEncryptFunction = new OraVarcharFunction(encryptfunction, decryptfunction);
        this.dateEncryptFunction = new OraDateFunction(encryptfunction, decryptfunction);
    }

    private static class OraDateFunction
    implements DbEncryptFunction {
        private final String encryptfunction;
        private final String decryptfunction;

        public OraDateFunction(String encryptfunction, String decryptfunction) {
            this.encryptfunction = encryptfunction;
            this.decryptfunction = decryptfunction;
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "to_date(" + this.decryptfunction + "(" + columnWithTableAlias + ",?),'YYYYMMDD')";
        }

        public String getEncryptBindSql() {
            return this.encryptfunction + "(to_char(?,'YYYYMMDD'),?)";
        }
    }

    private static class OraVarcharFunction
    implements DbEncryptFunction {
        private final String encryptfunction;
        private final String decryptfunction;

        public OraVarcharFunction(String encryptfunction, String decryptfunction) {
            this.encryptfunction = encryptfunction;
            this.decryptfunction = decryptfunction;
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return this.decryptfunction + "(" + columnWithTableAlias + ",?)";
        }

        public String getEncryptBindSql() {
            return this.encryptfunction + "(?,?)";
        }
    }
}

